import Vue from 'vue';
import Router from 'vue-router';
Vue.use(Router);

export default new Router({
  routes: [
    {
      path: '/',
      redirect: '/index'
    },
    {
      path: '/index',
      name: 'index',
      component: () => import('../components/Index.vue'),
      meta: {
        title: '测试页面'
      }
    }, 
    {
      path: '/start',
      name: 'start',
      component: () => import('../components/Start.vue'),
      meta: {
        title: '快速体验'
      }
    },
    {
      path: '/component',
      name: 'component',
      component: () => import('../components/ComponentsMain.vue'),
      redirect: '/component/guide',
      meta: {
        title: '开发文档'
      },
      children: [
        {
          path: '/component/guide',
          name: 'guide',
          component: r => require.ensure([], () => r(require('../docs/guide.md'))),
          meta: {
            title: '开发指南'
          }
        },
        {
          path: '/component/log',
          name: 'log',
          component: r => require.ensure([], () => r(require('../docs/log.md'))),
          meta: {
            title: '更新日志'
          }
        },
        {
          path: '/component/input',
          name: 'input',
          component: r => require.ensure([], () => r(require('../docs/input.md'))),
          meta: {
            title: '输入框'
          }
        }
      ]
    },
  ]
})




