/**
  *  @name 组件渲染配置文件
  *  @description 每个组件都有其对应的渲染规则,例如单选框就按照实际渲染，
  *               时间选择器需要转换成不同的时间格式，而按钮不需要渲染，
  *               所以产生此文件，用来配置每个组件需要渲染的格式
  *  @param { String } key 组件类型
  *  @param { String } value 该类型组件需要渲染的组件名称  
  *  @author liuguisheng
  *  @date  2019-11-21
  *  
*/

/**
 *                   目录    
 *                           （注意: 如果添加新的渲染类型，请及时更新此目录）
 * 
 * render-none .........................不需要渲染 （例如按钮）
 * render-text .........................文本类型
 * render-boolean ......................布尔类型
 * render-array ........................数组类型
 * render-real .........................是什么样就长什么样（例如分割线）
 * render-time .........................时间类型
 * render-date .........................日期类型
 * render-grid .........................栅格类型
 *
*/

export const renderComponents = {
    text: 'render-text',
    button: 'render-none',
    input: 'render-input',
    textarea: 'render-input',
    radio: 'render-input',
    checkbox: 'render-array',
    select: 'render-array',
    switch: 'render-boolean',
    datePicker: 'render-date',
    timePicker: 'render-time',
    uploadImage: 'render-image',
    uploadFile: 'render-file',
    grid: 'render-grid',
    free: 'render-free',
    line: 'render-none',
    domain: 'render-domain'
}