
/** @name 事件编辑配置管理者混入
 *  @author 王汝鹏
 *  @version 2019-12-24
 */
export const mixEventEditConfigManager = {
  methods: {
    /** @name 编辑事件配置管理者
     *  @param {Object} config 编辑事件配置
     *  @author 王汝鹏
     *  @version 2019-12-24
     */
    eventEditConfigManager(config) {
      let that = this;

      /** @name 获取事件id
       *  @return {String} 事件id
       *  @author 王汝鹏 
       *  @version 2019-12-24
       */
      const _getId = function() {
        return config.eventId;
      }

      /** @name 获取事件所有涉及的表单项id
       *  @return {Array} 表单项id集合
       *  @author 王汝鹏
       *  @version 2019-12-24
       */
      const _getFormIds = function() {
        let { emit, on } = config;
        let formIdSet = new Set([on.form, ...emit.map(e => e.form)]);
        formIdSet.delete(undefined);
        return [...formIdSet];
      }

      /** @name 添加事件关联项
       *  @return {Boolean} 操作结果
       *  @author 王汝鹏 
       *  @version 2019-12-24
       */
      const _addContact = function() {
        config.emit.push({
          form: undefined,
          type: 'change',
          value: undefined,
        })
        return true;
      }

      /** @name 移除事件关联项
       *  @param {Number} index 要删除的事件关联项索引
       *  @return {Boolean} 操作结果
       *  @author 王汝鹏
       *  @version 2019-12-24
       */
      const _removeContact = function(index) {
        config.emit.splice(index, 1);

      }
      /** @name 转化为提交数据格式
       *  @return {Object} 提交的事件格式
       *  @author 王汝鹏
       *  @version 2019-12-24
       */
      const _transform = function() {
        // { eventId:事件Id, eventType:事件类型, triggerType:触发类型, triggerValue:触发事件值, emit:事件触发者列表, on:事件监听者 }
        let {eventId, eventType, triggerForm, triggerType, triggerValue, emit, on} = config;

        // 将当前表单项触发配置转换为事件触发者格式
        let formEmitConfig = { form:triggerForm, type:triggerType, value:triggerValue };

        // 转换为提交格式事件配置
        let submitModel = { eventId, eventType, eventEmit:[...emit, formEmitConfig], eventOn:on };
        return submitModel;
      }

      return {
        getId() { return _getId(); },
        getFormIds() { return _getFormIds(); },
        addContact() { return _addContact(); },
        removeContact(index) { return _removeContact(index); },
        transform() { return _transform(); }
      }
    },
  }  
}
