

/** @name 表单项配置管理者混入
 *  @author 王汝鹏 
 *  @version 2019-12-24
 */
export const mixFormConfigManager = {
  methods: {
    /** @name 表单项配置管理者
     *  @param {Object} formConfig 表单项配置
     *  @return {Object} 表单配置操作
     *  @author 王汝鹏
     *  @version 2019-12-24
     */
    formConfigManager(config) {
      let that = this;

      /** @name 更新表单项id
       *  @param {String} id 表单项id
       *  @return {Boolean} 操作结果
       *  @author 王汝鹏
       *  @version 2019-12-24
       */
      const _setId = function(id) {
        config.node.selfId = id;
      }

      return {
        setId(id) { return _setId(id); }
      }
    }
  }
}

