

/** @name 表单项列表管理者混入
 *  @requires data {Array} formList 表单项节点列表
 *  @requires data {Array} activeList 激活表单节点所在列表
 *  @requires data {Object} activeNode 激活表单节点
 *  @requires mixin @/mixins/common/mix_form_node_manager.js
 *  @author 王汝鹏
 *  @version 2019-12-24
 */
export const mixFormListManager = {
  methods: {
    /** @name 表单列表管理者
     *  @author 王汝鹏 
     *  @version 2019-12-21
     */
    formListManager() {
      let that = this;

      /** @name 获取是否包含激活表单项节点
       *  @return {Boolean} 是否包含激活表单节点 { true:包含，false:不包含 }
       *  @author 王汝鹏
       *  @version 2019-12-24
       */
      const _hasActiveNode = function() {
        let activeIndex = that.activeList.findIndex(node => node.id === that.activeNode.id);
        return activeIndex !== -1;
      }

      /** @name 获取激活节点索引
       *  @return {Number} 激活节点所在列表索引
       *  @author 王汝鹏
       *  @version 2019-12-24
       */
      const _getActiveIndex = function() {
        let activeIndex = that.activeList.findIndex(node => node.id === that.activeNode.id);
        return activeIndex;
      }

      /** @name 激活表单项
       *  @param {Object} formNode 表单项节点
       *  @param {Array} formNodeList 表单项节点所在集合
       *  @return {Boolean} 操作结果 
       *  @author 王汝鹏
       *  @version 2019-12-21
       */
      const _activeNode = function(formNode, formNodeList) {
        that.activeList = formNodeList;
        that.activeNode = formNode;
      }

      /** @name 刷新表单列表
       *  @author 王汝鹏
       *  @version 2019-12-21
       */
      const _refreshList = function() {
        that.formList = that.formList;
        that.formMap = {...that.formMap};
      }

      /** @name 清空表单列表
       *  @author 王汝鹏
       *  @version 2019-12-21
       *  @updateInfo 2020-1-11 liuguisheng 添加变量设置删除
       */
      const _emptyList = function() {
        for (let node of [...that.formList]) {
          that.formNodeManager(node).deleteFrom(that.formList);
        }
        that.formList = [];
        that.activeNode = {};
        that.activeList = [];
        that.variableMap = {};
      }

      /** @name 获取列表节点数量
       *  @return {Number} 列表节点数量
       *  @author 王汝鹏
       *  @version 2019-12-22
       */
      const _getLength = function() {
        return that.formList.length;
      }

      return {
        activeNode(formNode, formNodeList) { return _activeNode(formNode, formNodeList); },
        refreshList() { return _refreshList(); },
        emptyList() { return _emptyList(); },
        getLength() { return _getLength(); },
        hasActiveNode() { return _hasActiveNode(); },
        getActiveIndex() { return _getActiveIndex(); }
      }
    },
  }
}
