
/** 工具方法 ::: 
 *  @function deepCopy 深拷贝方法
 */
import { deepCopy, produceNumber } from '@/utils/utils.js'
/** 配置数据 ::: 
 *  @data {Map<String,Number>} allFormTypeIndex 表单类型序号字典
 */
import { allFormTypeIndex, formTypeNameDictionary } from "@/assets/js/form_dictionary.js";


/** @name 表单项节点管理者混入
 *  @requires data {Object} formMap 表单项字典
 *  @requires mixin @/mixins/common/mix_event_config_manager.js
 *  @requires mixin @/mixins/common/mix_make_config_manager.js
 *  @author 王汝鹏
 *  @version 2019-12-24
 */
export const mixFormNodeManager = {
  methods: {
    formNodeManager(formNode) {
      let that = this;
      /** @name 判断节点配置是否相等
       *  @param {Object} compareConfig 要对比的节点配置
       *  @return {Boolean} 是否相等 {true:相等, false:不相等}
       *  @author 王汝鹏
       *  @version 2019-12-20
       */
      const _isEqual = function(compareConfig) {
        return formNode.id === compareConfig.id;
      }
      /** @name 删除当前节点
       *  @param {Array} list 表单节点所在列表
       *  @return {Boolean} 删除结果
       *  @author 王汝鹏
       *  @version 2019-12-21
       */
      const _deleteFrom = function(list) {
        let { id, children } = formNode;
        for (let childNode of children) {
          that.formNodeManager(childNode).deleteFrom(children);
        }
        // 删除表单项事件配置关系
        let event = that.formMap[id].event;
        let { emit, on } = event;
        for (let eventId of emit) { that.eventConfigManager(eventId).deleteEmitRelated(id); }
        for (let eventId of on) { that.eventConfigManager(eventId).deleteEvent(); }
        // 删除变量设置
        let { model } = that.formMap[id].baseOption;
        delete that.variableMap[model]
        // 删除表单项配置
        Reflect.deleteProperty(that.formMap, id);
        // 删除表单项
        let deleteIndex = list.findIndex(i => i.id === id);
        list.splice(deleteIndex, 1);
        that.formMap = { ...that.formMap };
      }
  
      /** @name 复制当前节点
       *  @return {Object} 复制的表单项节点
       *  @author 王汝鹏
       *  @version 2019-12-21
       */
      const _copy = function() {
        let { id, children } = formNode;
        let formConfig = that.formMap[id];
        if (!formConfig) return;
  
        // copy 表单项节点 
        let copyFormNode = that.makeFormNodeConfig();
        // copy 表单项配置 重新分配表单项id、变量名、显示名称
        let copyFormConfig = deepCopy(formConfig);
        let { type } = copyFormConfig.node;
        copyFormConfig.node.selfId = copyFormNode.id;
        copyFormConfig.baseOption.model = `${type}_${produceNumber(6)}`;
        allFormTypeIndex.set(type, allFormTypeIndex.get(type)+1);
        copyFormConfig.baseOption.customName = `${formTypeNameDictionary.get(type)}_${String(allFormTypeIndex.get(type)).padStart(8, '0')}`;
        copyFormConfig.event = { emit:[], on:[] };
  
        // 表单项注册到表单字典中
        that.formMap[copyFormNode.id] = copyFormConfig;
        // 复制当前表单项的子级节点
        copyFormNode.children = children.map(node => that.formNodeManager(node).copy());
  
  
        return copyFormNode;
      }
  
      /** @name 复制当前节点到列表中
       *  @param {Array} list 表单项节点所在列表
       *  @return {Boolean} 复制结果
       *  @author 王汝鹏
       *  @version 2019-12-21
       */
      const _copyTo = function(list) {
        let { id } = formNode;
        let formConfig = that.formMap[id];
        if (!formConfig) return false;
  
        let copyNode = that.formNodeManager(formNode).copy();
        let copyNodeConfig = that.formMap[copyNode.id];
        copyNodeConfig.node.isCopied = true;
        formConfig.node.copiedCount = formConfig.node.copiedCount + 1;
  
        let insertIndex = list.findIndex(node => node === formNode);
        list.splice(insertIndex+1, 0, copyNode);
        return true;
      }
  
      return {
        isEqual(compareConfig) { return _isEqual(compareConfig); },
        deleteFrom(list) { return _deleteFrom(list); },
        copy() { return _copy(); },
        copyTo(list) { return _copyTo(list); }
      }
    },
  }
}
