


/** 工具方法 ::: 
 *  @function produceNumber 随机数方法
 *  @function deepCopy 深拷贝方法
 */
import { produceNumber, deepCopy } from '@/utils/utils.js'
/** 配置数据 ::: 
 *  @data {Map<String,String>} formTypeNameDictionary 表单类型名称字典
 *  @data {Map<String,Number>} allFormTypeIndex 表单类型序号字典
 *  @data {Object} formConfigMap 表单配置字典
 */
import { formTypeNameDictionary, allFormTypeIndex, formConfigMap } from "@/assets/js/form_dictionary.js";


/** @name 生成默认配置混入
 *  @requires 
 *  @author 王汝鹏
 *  @version 2019-12-24
 */
export const mixMakeConfigManager = {
  methods: {
    /** @name 生成表单项配置
     *  @param {String} type 表单项类型
     *  @return {Object} 表单项配置
     *  @author 王汝鹏
     *  @version 2019-12-24
     */
    makeFormConfig(type) {
      if (Reflect.has(formConfigMap, type) === false) throw new Error(`不存在 ${type} 类型表单配置.`);

      allFormTypeIndex.set(type, allFormTypeIndex.get(type)+1);
      // copy类型默认配置
      let copyConfig = deepCopy(formConfigMap[type]);
      // 分配表单项显示名称
      copyConfig.baseOption.customName = `${formTypeNameDictionary.get(type)}_${String(allFormTypeIndex.get(type)).padStart(8, '0')}`;
      // 分配表单项变量名
      Reflect.has(copyConfig.baseOption, 'model') && (copyConfig.baseOption.model = `${type}_${produceNumber(6)}`);

      return copyConfig;
    },

    /** @name 获取默认事件配置
     *  @param {String} formId 表单项id
     *  @reutrn {Object} 默认事件配置
     *  @author 王汝鹏
     *  @version 2019-12-24
     */
    makeEventConfig(formId) {
      return {
        eventId: produceNumber(6),                // 事件id
        eventType: undefined,                      // 事件类型（并且、或者）
        triggerForm: formId,                       // 触发表单项id
        triggerType: "change",                     // 触发事件类型（默认值改变）
        triggerValue: undefined,                   // 触发事件的值
        emit: [],                                  // 触发事件表单项配置列表
        on: { form:undefined, action:undefined }   // 监听事件表单项配置
      }
    },

    /** @name 生成新表单项节点配置
     *  @return {Object} 表单项节点配置
     *  @author 王汝鹏
     *  @version 2019-12-21
     */
    makeFormNodeConfig() {
      return {
        id: `${produceNumber(6)}`,
        children: [],
      }
    },

    /** @name 生成/获取 分组组件配置
     *  @param {String} domainName 模块名称
     *  @param {Array} templates 领域模版数据
     *  @return {Object} 模块组件数据
     *  @author 王汝鹏
     *  @version 2019-12-21
     */
    makeDomainConfig(domainName, templates) {
      let groupId = produceNumber(6)
      return {
        exhibits: {
          type: "domain",
          name: domainName,
          icon: "iconmokuai",
        },
        node: { 
          id: groupId,
          children: templates,
        },
        config: {
          node: { 
            type: "domain",
            selfId: groupId
          },
          baseOption: {},
          styleOption: {},
          renderOption: {},
          event: {emit:[],on:[]},
        }
      }
    },
  }
}