
const package = require('../package.json')
const webpack = require('webpack')
const ora = require('ora')
const path = require('path')
const chalk = require('chalk')
const spinner = ora('building for production...')
spinner.start()

function resolve (dir) {
  return path.join(__dirname, '..', dir)
}

const webpackConfig = {
  entry: "./src/npm.js",
  output: {
    filename: 'index.js',
    chunkFilename: '[id].js',
    libraryTarget: 'umd',
    libraryExport: 'default',
    library: 'form-making-rice',
    umdNamedDefine: true,
    path: path.resolve(__dirname, `../dist/libs@${package.version}`),
  },
  resolve: {
    extensions: ['.js', '.vue', '.json'],
    alias: { 'vue$': 'vue/dist/vue.esm.js', '@': resolve('src') }
  },
  externals: {
    'vue': {
      root: 'Vue',
      commonjs: 'vue',
      commonjs2: 'vue',
      amd: 'vue'
    },
    'element-ui': 'element-ui'
  },
  module: {
    rules: [
      {
        test: /\.vue$/,
        loader: 'vue-loader',
      },
      {
        test: /\.(sass|scss)$/,
        loaders: ['style', 'css', 'sass', "scss"]
      },
      {
        test: /\.js$/,
        exclude: /(node_modules|bower_components)/,
        loader: 'babel-loader',
        include: [resolve('examples'), resolve('src'),resolve('packages')]
      },
      {
        test:/\.(ttf|eot|woff|woff2|svg)$/,
        use:['file-loader']
      },
      {
        test: /\.(css|scss)$/,
        use: [
          { loader: "style-loader" },
          { loader: "css-loader" },
          { loader: "sass-loader"}
        ],
      },
    ]
  },
  plugins: [ 
    new webpack.optimize.UglifyJsPlugin({
      compress: {
        warnings: false,
        drop_debugger: true,
        drop_console: true
      },
      sourceMap: true
    })
  ]
}

webpack(webpackConfig, (err, stats) => {
  spinner.stop()
  console.log(chalk.cyan('sucess.\n'))
  console.log(`
  ***********************************************************
        打包成功
        包名称: ${webpackConfig.output.library}          
        版本号: ${package.version}                         
  ***********************************************************
  `)
});

