

/** @name 分组组件管理者混入
 *  @requires data {Object} formMap 表单项字典
 *  @requires data {Array} domainList 分组列表
 *  @requires mixin @/mixins/common/mix_form_node_manager.js
 *  @author 王汝鹏
 *  @version 2019-12-24
 */
export const mixDomainManager = {
  methods: {
    /** @name 分组组件管理者
     *  @param {Object} domain 表单分组配置
     *  @author 王汝鹏 
     *  @version 2019-12-22
     */
    domainManager(domain) {
      let that = this;

      /** @name 更新表单分组模版
       *  @param {Array} templates 分组模版
       *  @return {Boolean} 操作结果
       *  @author 王汝鹏
       *  @version 2019-12-22
       */
      const _setTemplates = function(templates) {
        domain.node.children = templates;
        return true;
      }
      /** @name 获取分组模版
       *  @return {Array} 分组模版
       *  @author 王汝鹏
       *  @version 2019-12-22
       */
      const _getTemplates = function() {
        return domain.node.children;
      }

      /** @name 获取分组名称
       *  @return {String} 分组名称
       *  @author 王汝鹏
       *  @version 2019-12-22
       */
      const _getName = function() {
        return domain.exhibits.name;
      }

      /** @name 设置分组名称
       *  @return {Boolean} 操作结果
       *  @author 王汝鹏 
       *  @version 2020-01-05
       */
      const _setName = function(name) {
        domain.exhibits.name = name;
        return true;
      }

      /** @name 获取分组图标
       *  @return {String} 分组图标
       *  @author 王汝鹏
       *  @version 2019-12-22
       */
      const _getIcon = function() {
        return domain.exhibits.icon;
      }

      /** @name 删除分组
       *  @return {Boolean} 操作结果
       *  @author 王汝鹏
       *  @version 2019-12-22
       */
      const _delete = function() {
        let deleteIndex = that.domainList.findIndex(i => i.node.id === domain.node.id);
        let domainTemplates = that.domainManager(domain).getTemplates();
        for (let node of [...domainTemplates]) {
          that.formNodeManager(node).deleteFrom(domainTemplates);
        }
        that.domainList.splice(deleteIndex, 1);
        return true;
      }

      /** @name 获取模块组件节点
       *  @return {Object} 模块组件节点
       *  @author 王汝鹏
       *  @version 2019-12-23
       */
      const _getNode = function() {
        // 将模块注册到表单项字典中
        let { node, config } = domain;
        that.formMap[node.id] = config;
        
        return node;
      } 

      return {
        getName() { return _getName(); },
        setName(name) { return _setName(name); },
        getIcon() { return _getIcon(); },
        getTemplates() { return _getTemplates(); },
        setTemplates(templates) { return _setTemplates(templates); },
        getNode() { return _getNode(); },
        delete() { return _delete(); }
      }
    },
  }
}
