
/** 配置数据 ::: 
 *  @param {Object} renderComponents 渲染组件字典数据
 */
import { renderComponents } from "@/assets/js/render_data.js";
/** 工具方法 ::: 
 *  @function cmToPx 厘米转像素
 */
import { cmToPx, measureFormat } from '@/utils/unit_format.js';


/** @name 表单项属性解构混入
 *  @requires data {Object} formMap 表单项字典
 *  @requires data {Object} formModels 表单填写数据
 *  @author 王汝鹏
 *  @version 2019-10-26
 */
export const mixFormConfig = {
  props: {
    formNode: {
      type: Object,
      required: true
    }
  },
  computed: {
    formConfig() { return this.formMap[this.formNode.id] || {} },
    formNodeConfig() { return this.formConfig.node || {} },
    formBaseOptionConfig() { return this.formConfig.baseOption || {} },
    formStyleOptionConfig() { return this.formConfig.styleOption || {} },
    formRenderOptionConfig() { return this.formConfig.renderOption || {} },
    formEventConfig() { return this.formConfig.event || {} },

    // node Config
    formType() { return this.formNodeConfig.type },
    selfId() { return this.formNodeConfig.selfId },
    isCopied() { return this.formNodeConfig.isCopied },
    copiedCount() { return this.formNodeConfig.copiedCount },

    // baseOption Config
    textLength () { return this.formBaseOptionConfig.textLength },
    labelName() { return this.formBaseOptionConfig.labelName },
    customName() { return this.formBaseOptionConfig.customName },
    model() { return this.formBaseOptionConfig.model },
    defaultValue() { return this.formBaseOptionConfig.defaultValue },
    placeholder() { return this.formBaseOptionConfig.placeholder },
    buttonType() { return this.formBaseOptionConfig.buttonType },
    buttonSize() { return this.formBaseOptionConfig.buttonSize },
    buttonBack() { return this.formBaseOptionConfig.buttonBack },
    buttonLoading() { return this.formBaseOptionConfig.buttonLoading },
    buttonThrottle() { return this.formBaseOptionConfig.buttonThrottle },
    buttonText() { return this.formBaseOptionConfig.buttonText },
    isDisplay() { return this.formBaseOptionConfig.isDisplay },
    isClearable() { return this.formBaseOptionConfig.isClearable },
    isDisabled() { return this.formBaseOptionConfig.isDisable },
    isReadonly() { return this.formBaseOptionConfig.isReadonly },
    isEditable() { return this.formBaseOptionConfig.isEditable },
    isMultiple() { return this.formBaseOptionConfig.multiple },
    displayType() { return this.formBaseOptionConfig.displayType || 'inline-block' },
    dateType() { return this.formBaseOptionConfig.dateType },
    dateFormat() { return this.formBaseOptionConfig.dateFormat },
    lineText() { return this.formBaseOptionConfig.lineText },
    textPosition() { return this.formBaseOptionConfig.textPosition },
    lineStyle() { return this.formBaseOptionConfig.lineType },
    uploadLimit () { return this.formBaseOptionConfig.limit },
    uploadHost () { return this.formBaseOptionConfig.ossHost },
    gridAlign() { return this.formBaseOptionConfig.align || 'top' },
    gridGutter() { return this.formBaseOptionConfig.gutter || 0 },
    gridJustify() { return this.formBaseOptionConfig.justify || 'start' },
    autosizeMinRows() { return this.formBaseOptionConfig.autosizeMinRows },
    autosizeMaxRows() { return this.formBaseOptionConfig.autosizeMaxRows },
    autosize() { return { minRows:this.autosizeMinRows, maxRows:this.autosizeMaxRows } },

    // styleOption Config
    customClass() { return this.formStyleOptionConfig.customClass },
    width() { return `${cmToPx(this.formStyleOptionConfig.width)}px` },
    height() { return `${cmToPx(this.formStyleOptionConfig.height)}px`},
    labelWidth() { return `${cmToPx(this.formStyleOptionConfig.labelWidth)}px` },
    labelPosition() { return this.formStyleOptionConfig.labelPosition },
    labelTextPosition() { return this.formStyleOptionConfig.labelTextPosition },
    title() { return this.formStyleOptionConfig.title },
    wordWeight () { return this.title === "12" ? 500 : 600 },
    wordLineHeight () { return this.title === '12' ? "20px" : (this.title*1.5 + 'px');},
    color () { return this.formStyleOptionConfig.color },
    paddingLeft () { return `${cmToPx(this.formStyleOptionConfig.paddingLeft)}px` },
    
    // renderOption Config
    currentModel() { return this.formModels ? this.formModels[this.model] : undefined; },
    renderType() { return renderComponents[this.formType]; },
    strong() { return this.formRenderOptionConfig.strong },
    underline() { return this.formRenderOptionConfig.underline },
    isUnderline() { return this.formRenderOptionConfig.isUnderline },
    showUnderline() { return this.underline > 0; },
    showTextUnderline() { return this.underline; },
    italic() { return this.formRenderOptionConfig.italic },
    wrap() { return this.formRenderOptionConfig.wrap },
    indent() { return this.formRenderOptionConfig.indent || 0 },
    align() { return this.formRenderOptionConfig.align },
    fontSize() { return measureFormat(this.formRenderOptionConfig.fontSize || 16); },
    lineHeight() { return this.formRenderOptionConfig.lineHeight ? this.formRenderOptionConfig.lineHeight : 40 + 'px'; },
    fullLine() { return (this.align && (this.align !== 'none')); },
    showRule() { return this.formRenderOptionConfig.showRule },
    seat() { return this.formRenderOptionConfig.seat || ''},
    nullRender() { return this.formRenderOptionConfig.nullRender || '1'},
    whereColor () { return this.formRenderOptionConfig.whereColor },
    renderColor () { return this.formRenderOptionConfig.renderColor },
    

    /** 特殊格式 **/
    validator() { return this.formBaseOptionConfig.validator || {} },
    options() { return this.formBaseOptionConfig.options },
    dateFilter() { return this.formBaseOptionConfig.dateFilter },
    gridColumns() { return this.formBaseOptionConfig.columns || [] },  // 类型已经变更
    freeItemList: {
      get() { return this.formBaseOptionConfig.list },
      set(newValue) { this.formBaseOptionConfig.list = newValue; }
    },
  },
}
