

/** @name 展示表单项混入
 *  @author 王汝鹏 
 *  @version 2019-12-24
 */
export const mixFormExhibitsManager = {
  methods: {
    /** @name 展示表单项管理者
     *  @param {Object} config 展示表单项配置
     *  @return {Object} 展示表单项操作方法集合
     *  @author 王汝鹏
     *  @version 2019-12-24
     */
    formExhibitsManager(config) {
      let that = this;

      /** @name 获取展示表单项名称
       *  @return {String} 展示表单项名称
       *  @author 王汝鹏
       *  @version 2019-12-24
       */
      const _getName = function() {
        return config.name;
      }

      /** @name 获取展示表单项图标
       *  @return {String} 展示表单项图标
       *  @author 王汝鹏
       *  @version 2019-12-24
       */
      const _getIcon = function() {
        return config.icon;
      }

      /** @name 获取展示表单项类型
       *  @return {String} 展示表单项类型
       *  @author 王汝鹏
       *  @version 2019-12-24
       */
      const _getType = function() {
        return config.type;
      }

      return {
        getName() { return _getName(); },
        getType() { return _getType(); },
        getIcon() { return _getIcon(); }      
      }
    },
  }  
}
