

/** @name 节点事件行为管理者混入
 *  @requires data {Object} formMap 表单项字典
 *  @requires mixin @/mixins/common/mix_form_node_manager.js
 *  @author 王汝鹏
 *  @version 2019-12-24
 */
export const mixNodeActionManager = {
  methods: {
    /** @name 节点事件行为管理者
     *  @param {Object} formNode 表单项节点
     *  @return {Object} 节点行为
     *  @author 王汝鹏
     *  @version 2019-12-23
     */
    nodeActionManager(formNode) {
      let that = this;

      /** @name 表单节点显示行为
       *  @return {Boolean} 操作结果
       *  @author 王汝鹏
       *  @version 2019-12-23
       */
      const _display = function() {
        let formConfig = that.formMap[formNode.id];
        formConfig.baseOption.isDisplay = true;
      }

      /** @name 表单节点隐藏行为
       *  @return {Boolean} 操作结果
       *  @author 王汝鹏 
       *  @version 2019-12-23
       */
      const _hide = function() {
        let formConfig = that.formMap[formNode.id];
        formConfig.baseOption.isDisplay = false;
      }

      /** @name 表单节点复制行为
       *  @param {Object} parent 节点父级
       *  @return {Boolean} 操作结果
       *  @author 王汝鹏
       *  @version 2019-12-23
       */
      const _copyTo = function(parent) {
        that.formNodeManager(formNode).copyTo(parent);
      }

      /** @name 表单节点删除行为
       *  @param {Object} parent 节点父级
       *  @return {Boolean} 操作结果
       *  @author 王汝鹏
       *  @version 2019-12-23
       */
      const _deleteFrom = function(parent) {
        that.formNodeManager(formNode).deleteFrom(parent);
      }

      /** @name 表单节点禁用行为
       *  @return {Boolean} 操作结果
       *  @author 王汝鹏 
       *  @version 2019-12-23
       */
      const _disable = function() {
        let formConfig = that.formMap[formNode.id];
        formConfig.baseOption.isDisable = true;
      }

      /** @name 表单节点解禁行为
       *  @return {Boolean} 操作结果
       *  @author 王汝鹏
       *  @version 2019-12-23
       */
      const _enable = function() {
        let formConfig = that.formMap[formNode.id];
        formConfig.baseOption.isDisable = false;
      }

      return {
        display() { return _display(); },
        hide() { return _hide(); },
        copyTo(parent) { return _copyTo(parent); },
        deleteFrom(parent) { return _deleteFrom(parent); },
        disable() { return _disable(); },
        enable() { return _enable(); }
      }
    }
  }
}
