// 导入上传工具
import { upload } from '@/utils/upload.js';

/** 
 * @name 上传混入文件
 * @author 王汝鹏
 * @version 2019-09-16
 */
export default {
  data() {
    return {
      fileListData: [],
    }
  },
  methods: {
    /** @name 删除图片
     *  @description 删除后的文件地址存储到组件值中
     *  @param {Object} file 文件对象
     *  - {String} name 文件名称
     *  - {Number} size
     *  - {String} status
     *  - {String} url
     *  @param {Array} fileList 删除后的文件列表
     *  @author 王汝鹏
     *  @version 2019-09-16
     */
    handleRemove(file, fileList) {
      this.uploadFileList = fileList;
    },
    /** @name 上传图片到阿里云
     *  @description 读取组件配置，上传图片到阿里云，更新组件上传图片值
     *  @param {Object} file 文件对象
     *  @author 王汝鹏
     *  @version 2019-09-16
     */
    async uploadImage({file}) {
      try {
        //  上传图片
        let previewPath = await upload(file, this.ossConfig);
        //  更新已上传文件列表
        this.uploadFileList = [...this.uploadFileList, {
          name: file.name,
          url: `${previewPath}?name=${file.name}`
        }];
      } catch (err) { console.log('uploadImageError: ', err); }
    },
    /** @name 超出最大上传个数钩子
     *  @returns { void }
     *  @author liuguisheng
     *  @version 2019-11-13
     */
    handleExceed () {
      this.$message({type: 'warning', message: '超出最大上传个数！'})
    }
  },
  computed: {
    /** @name 已经上传的图片
     *  @return {Array}
     *  @author 王汝鹏
     *  @version 2019-09-16
     */
    uploadFileList: {
      get() {
        let fileList = this.currentModel || [];
        let result = fileList.map((url, index) => {
          let query = url.split("?")[1];
          let params = (query||"").split("&");
          let paramMap = new Map();
          for (let param of params) {
            let [key, value] = param.split('=');
            paramMap.set(key, value);
          }
          return { name: paramMap.get("name") || `${index}`, url };
        })
        
        return result;
      },
      set(newValue) {
        this.currentModel = newValue.map(({name, url}) => url);
      }
    },
    /** @name 展示的已上传文件列表
     *  @description 解决数据变化时，整个组件渲染图片列表跳动问题，缓存一份数据，对比数据判断是否刷新
     *  @author 王汝鹏
     *  @version 2019-12-02
     */
    showFileListData() {
      // 两个数据的长度不一样,说明数据肯定发生了变更
      if (this.uploadFileList.length !== this.fileListData.length) { 
        this.fileListData = this.uploadFileList;
      } else {
        // 对比数据是否一致
        let fileListMap = new Map(this.fileListData.map(({name, url}) => [url, name]))
        for (let {name, url} of this.uploadFileList) {
          if (fileListMap.get(url) !== name) {
            this.fileListData = this.uploadFileList;
            break;
          }
        }
      }
      return this.fileListData;
    },
    /** @name 阿里云配置
     *  @return {Object}
     *  @author 王汝鹏
     *  @version 2019-09-20
     */
    ossConfig() {
      let config = this.formBaseOptionConfig;
      let ossConfig = {
        uploadHost: config.ossHost,
        region: config.ossRegion,
        bucket: config.ossBucket,
        fileDir: config.ossDir,
        accessKeyId: config.accessKeyId,
        accessKeySecret: config.accessKeySecret
      }
      return ossConfig;
    }
  }
}