
/************************************************
 @function produceNumber 生成随机数方法
 @function objTransformArr 对象转数组方法
 @function objectEmptyCheck 校验对象的各个属性是否为空
 @function deepCopy 对象深拷贝
 ************************************************/


/** 
 * @name 生成随机数方法
 * @param {Number} length 随机字符串长度
 * @param {Boolean} isDate 是否添加时间戳 (default: true)
 * @return {String} 
 * @author liuguisheng
 * @version 2019-9-11
 */
export const produceNumber = function(length, isDate=true) {
  length = length || 32;
  let chars = 'ABCDEFGHJKMNPQRSTWXYZabcdefhijkmnprstwxyz23456789';
  // 字符长度(maxLength)和随机数(randomNumber)定义
  let maxLength = chars.length, randomNumber = '';
  // 添加随机数
  for (let i = 0; i < length; i++) {
    randomNumber += chars.charAt(Math.floor(Math.random() * maxLength));
  }
  // 如果设置时间戳拼接到随机数后边,否则直接抛出
  return isDate ? randomNumber + new Date().getTime() : randomNumber;
}

/**
 * @name 对象转数组方法
 * @params { Object } obj 需要转换的对象
 * @return { Array } 转换后的数组
 * @author liuguihsheng
 * @version 2019-9-14
 * 
*/
export const objTransformArr = function(obj) {
  let arr = [];
  // 开始转换并抛出
  for(let i in obj)  arr.push(obj[i]);
  return arr;
}

